function CDX = CDX_copy_parameters(CDX, CDX2, dates2)
% --------------------------------------------------------------------------------------------------
% For a credit index structure with time-varying parameters, copy the parameters and initial
% intensities of 'CDX2' for dates 'dates2' into 'CDX'.
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% CDX2      ... 2nd credit index structure (see 'all_steps_in_a_row.m')
% dates2    ... dates for which to copy parameters
% --------------------------------------------------------------------------------------------------
% sample call: CDX_copy_parameters(CDX_NA_IG2, cdx_tv_yearly, cdx_tv_yearly.dates{1}(1:2))
% --------------------------------------------------------------------------------------------------

% Copy CDX parameters
[trash, cdx_pos, cdx2_pos, trash2] = intersect_triple(CDX.dates{1}, CDX2.dates{1}, dates2);
CDX.y0(cdx_pos,:) = CDX2.y0(cdx2_pos);
CDX.liq_prem_tranches(cdx_pos,:) = CDX2.liq_prem_tranches(cdx2_pos);
CDX.liq_prem_cds(cdx_pos,:) = CDX2.liq_prem_cds(cdx2_pos);
for i=1:length(CDX.tranche_model_upfront)
    [trash, cdx_pos_M, cdx2_pos_M, trash2] = intersect_triple(CDX.dates{i}, CDX2.dates{i}, dates2);
    CDX.tranche_model_upfront{i}(cdx_pos_M,:) = CDX2.tranche_model_upfront{i}(cdx2_pos_M,:);
end
for i=1:length(CDX.tranche_model_price)
    [trash, cdx_pos_M, cdx2_pos_M, trash2] = intersect_triple(CDX.dates{i}, CDX2.dates{i}, dates2);
    CDX.tranche_model_price{i}(cdx_pos_M,:) = CDX2.tranche_model_price{i}(cdx2_pos_M,:);
end
if (isfield(CDX, 'PV01'))
    for i=1:length(CDX.PV01)
        [trash, cdx_pos_M, cdx2_pos_M, trash2] = intersect_triple(CDX.dates{i}, CDX2.dates{i}, dates2);
        CDX.PV01{i}(cdx_pos_M,:) = CDX2.PV01{i}(cdx2_pos_M,:);
    end
end
CDX.rmse(cdx_pos,:) = CDX2.rmse(cdx2_pos);

% Copy common factor AJD parameters
CDX.AJD_common_factor.k(cdx_pos,:) = CDX2.AJD_common_factor.k(cdx2_pos);
CDX.AJD_common_factor.theta(cdx_pos,:) = CDX2.AJD_common_factor.theta(cdx2_pos);
CDX.AJD_common_factor.sigma(cdx_pos,:) = CDX2.AJD_common_factor.sigma(cdx2_pos);
CDX.AJD_common_factor.L(cdx_pos,:) = CDX2.AJD_common_factor.L(cdx2_pos);
CDX.AJD_common_factor.mu(cdx_pos,:) = CDX2.AJD_common_factor.mu(cdx2_pos);

% Copy CDS parameters
tickers = {CDX.portfolio.ticker}';
tickers2 = {CDX2.portfolio.ticker}';
for i=1:length(CDX2.portfolio)
    % Find matching CDS
    pos = find(strcmp(tickers, tickers2{i}));
    if (isempty(pos))
        continue;
    end
    
    % Copy CDS parameters
    cds = CDX.portfolio(pos);
    cds2 = CDX2.portfolio(i);
    [trash, cds_pos, cds2_pos, trash2] = intersect_triple(cds.dates{1}, cds2.dates{1}, dates2);
    if (isempty(cds_pos) | isempty(cds2_pos))
        continue;
    end
    cds.x0(cds_pos,:) = cds2.x0(cds2_pos);
    cds.ai(cds_pos,:) = cds2.ai(cds2_pos);
    cds.bi(cds_pos,:) = cds2.bi(cds2_pos);
    if (isfield(cds2, 'ai_P')) & (~isempty(cds2.ai_P))
        cds.ai_P(cds_pos,:) = cds2.ai_P(cds2_pos);
    end
    if (isfield(cds2, 'bi_P')) & (~isempty(cds2.bi_P))
        cds.bi_P(cds_pos,:) = cds2.bi_P(cds2_pos);
    end
    for j=1:length(cds.model_price)
        if (length(cds2.model_price{j}) > 0)
            [trash, cds_pos_M, cds2_pos_M, trash2] = intersect_triple(cds.dates{j}, cds2.dates{j}, dates2);
            if isempty(cds.model_price{j}) 
                cds.model_price{j} = zeros(length(cds.dates{1}), 1);
            end
            cds.model_price{j}(cds_pos_M,:) = cds2.model_price{j}(cds2_pos_M,:);
        end
    end

    % Copy CDS AJD parameters
    cds.AJD.k(cds_pos,:) = cds2.AJD.k(cds2_pos);
    cds.AJD.theta(cds_pos,:) = cds2.AJD.theta(cds2_pos);
    cds.AJD.sigma(cds_pos,:) = cds2.AJD.sigma(cds2_pos);
    cds.AJD.L(cds_pos,:) = cds2.AJD.L(cds2_pos);
    cds.AJD.mu(cds_pos,:) = cds2.AJD.mu(cds2_pos);
    cds.AJD.dates = cds.dates{1};
    
    % Re-insert CDS into CDX structure
    CDX.portfolio(pos) = cds;
end



